#!/usr/bin/Rscript
printf("# Check CONUS results\n")
runs_conus <- read.csv("runs_conus.csv", stringsAsFactors=T)

# reorder factors
runs_conus$method <- factor(runs_conus$method,
		      levels=c("meuflm",  # more memory
			       "meufll",  # less memory
			       "meuflL")) # least memory

# rename factors
levels(runs_conus$method) <- c("MEUFLm", "MEUFLl", "MEUFLL")

methods <- levels(runs_conus$method)

# check failed runs
printf("## Check failed runs\n")
n <- sum(runs_conus$md5sum=="")
if(n) printf("%d failed runs\n", n) else printf("Passed\n")

# check md5sums for each method
printf("## Check md5sums for each method\n")
x <- c()
for(m in methods){
	n <- length(unique(runs_conus$md5sum[runs_conus$method==m]))
	if(n > 1 && !(m %in% x))
		x <- c(x, m)
}
if(length(x)) print(x) else printf("Passed\n")

# check md5sums between MEUFL methods
printf("## Check md5sums between MEUFL methods\n")
x <- c()
n <- length(unique(runs_conus$md5sum[runs_conus$method %in% c("MEUFLm",
							      "MEUFLl",
							      "MEUFLL")]))
if(n > 1 && !(o %in% x))
	x <- c(x, o)
if(length(x)) print(x) else printf("Passed\n")

################################################################################
printf("# Check state results\n")
runs_states <- read.csv("runs_states.csv", stringsAsFactors=T)

# reorder factors
runs_states$method <- factor(runs_states$method,
		      levels=c("meuflm",  # more memory
			       "meufll",  # less memory
			       "meuflL")) # least memory

# rename factors
levels(runs_states$method) <- c("MEUFLm", "MEUFLl", "MEUFLL")

methods <- levels(runs_states$method)
states <- sort(unique(runs_states$stusps))

# check failed runs
printf("## Check failed runs\n")
n <- sum(runs_states$md5sum=="")
if(n) printf("%d failed runs\n", n) else printf("Passed\n")

# check md5sums for each method
printf("## Check md5sums for each method\n")
x <- c()
for(s in states){
	for(m in methods){
		n <- length(unique(runs_states$md5sum[runs_states$stusps==s&
				   runs_states$method==m]))
		if(n > 1 && !(m %in% x))
			x <- c(x, m)
	}
}
if(length(x)) print(x) else printf("Passed\n")

# check md5sums between MEUFL methods
printf("## Check md5sums between MEUFL methods\n")
x <- c()
for(s in states){
	n <- length(unique(runs_states$md5sum[runs_states$stusps==s&
			   runs_states$method %in% c("MEUFLm",
						     "MEUFLl",
						     "MEUFLL")]))
	if(n > 1 && !(o %in% x))
		x <- c(x, o)
}
if(length(x)) print(x) else printf("Passed\n")

################################################################################
printf("# Check county results\n")
runs_counties <- read.csv("runs_counties.csv", stringsAsFactors=T)

# reorder factors
runs_counties$method <- factor(runs_counties$method,
		      levels=c("meuflm",  # more memory
			       "meufll",  # less memory
			       "meuflL")) # least memory

# rename factors
levels(runs_counties$method) <- c("MEUFLm", "MEUFLl", "MEUFLL")

methods <- levels(runs_counties$method)
counties <- sort(unique(runs_counties$countyfp))

# check failed runs
printf("## Check failed runs\n")
n <- sum(runs_counties$md5sum=="")
if(n) printf("%d failed runs\n", n) else printf("Passed\n")

# check md5sums for each method
printf("## Check md5sums for each method\n")
x <- c()
for(c in counties){
	for(m in methods){
		n <- length(unique(runs_counties$md5sum[
				   runs_counties$countyns==c&
				   runs_counties$method==m]))
		if(n > 1 && !(m %in% x))
			x <- c(x, m)
	}
}
if(length(x)) print(x) else printf("Passed\n")

# check md5sums between MEUFL methods
printf("## Check md5sums between MEUFL methods\n")
x <- c()
for(c in counties){
	n <- length(unique(runs_counties$md5sum[
			   runs_counties$countyns==c&
			   runs_counties$method %in% c("MEUFLm",
						       "MEUFLl",
						       "MEUFLL")]))
	if(n > 1 && !(o %in% x))
		x <- c(x, o)
}
if(length(x)) print(x) else printf("Passed\n")
