#!/bin/sh
num_threads=$(nproc)
num_trials=5
[ -d logs ] || mkdir logs
[ -d outputs ] || mkdir outputs
[ -f runs.csv ] || echo "threads,trial,stusps,method,md5sum,compute,run,cpu,mempeak,memaccess" > runs.csv
for i in $(seq 1 $num_trials); do
	i=$(echo "$num_trials*$(hostname -s | tr -d a-z)+$i" | bc)
	for t in $(seq $num_threads); do
		export OMP_NUM_THREADS=$t
		for fdr in inputs/fdr_*.tif; do
			s=$(echo $fdr | sed 's/.*_\|\..*//g' | tr a-z A-Z)
			for m in meuflm meufll meuflL; do
				grep -q "^$t,$i,$s,$m," runs.csv && continue
				log=logs/${m}_${s}_${t}_$i.log
				case $m in
				meufl*)
					prog=meufl
					case $m in
					meuflm)
						opts=
						;;
					meufll)
						opts=-l
						;;
					meuflL)
						opts=-L
						;;
					esac
					output=outputs/${prog}_$s.tif
					(/usr/bin/time -v ../bin/$prog $opts $fdr $output) >& $log
					compute=$(awk '/Computation/{print $(NF-1)/1000000}' $log)
					;;
				esac
				run=$(awk '/^\tElapsed/{print $NF}' $log | awk -F: '{s=$1*60+$2; if(NF==3)s=s*60+$3; print s}')
				# %M did not work well for clfp*; use %R
				# https://stackoverflow.com/a/998537/16079666
				# "Most people use the number of minor pagefaults (1 == 4Kb block) as indication for the amount of memory used."
				# https://web.archive.org/web/20100323050750/http://kerneltrap.org/mailarchive/git/2008/1/29/647169
				# "It finally finished with time reporting:
				#
				#	208.15user 3.50system 4:01.50elapsed 87%CPU (0avgtext+0avgdata 0maxresident)k
				#	238736inputs+4544outputs (8261major+280971minor)pagefaults 0swaps
				#
				# where those 280971 minor page faults are what largely indicates how much
				# memory it used (the technical term for that number is "metric buttload of
				# memory")."
				cpu=$(awk '/^\tPercent/{print $NF/100}' $log)
				mempeak=$(awk '/^\tMaximum/{print $NF*1024}' $log)
				memaccess=$(awk '/^\tMinor/{print $NF*4*1024}' $log)
				if [ "$compute" = "" ]; then
					md5sum=
				else
					md5sum=$(md5sum $output | sed 's/ .*//')
				fi
				echo "$t,$i,$s,$m,$md5sum,$compute,$run,$cpu,$mempeak,$memaccess" >> runs.csv
			done
		done
	done
done
